-- 创建多语言内容表
CREATE TABLE IF NOT EXISTS i18n_content (
  id VARCHAR(100) PRIMARY KEY,
  group_name VARCHAR(50) NOT NULL,
  key_name VARCHAR(100) NOT NULL,
  content_zh TEXT,
  content_ru TEXT,
  description TEXT,
  sort_order INTEGER DEFAULT 0,
  created_at TIMESTAMP DEFAULT NOW(),
  updated_at TIMESTAMP DEFAULT NOW()
);

-- 创建索引
CREATE INDEX IF NOT EXISTS idx_i18n_group ON i18n_content(group_name);
CREATE INDEX IF NOT EXISTS idx_i18n_sort ON i18n_content(sort_order);

-- 插入默认首页内容
INSERT INTO i18n_content (id, group_name, key_name, content_zh, content_ru, description, sort_order) VALUES
-- Hero区域
('hero_title', 'home', 'heroTitle', '打通中俄物流全链路', 'Полная логистическая цепочка Китай-Россия', '首页主标题', 1),
('hero_subtitle', 'home', 'heroSubtitle', '让跨境运输更简单', 'Упрощаем трансграничные перевозки', '首页副标题', 2),
('hero_desc', 'home', 'heroDesc', '专业的中俄跨境物流解决方案提供商，为您的货物保驾护航', 'Профессиональный провайдер логистических решений Китай-Россия', '首页描述', 3),

-- 数据统计
('stats_years_value', 'home', 'statsYearsValue', '10', '10', '数据统计-年数', 10),
('stats_years_label', 'home', 'statsYearsLabel', '行业深耕年限', 'лет опыта', '数据统计-年数标签', 11),
('stats_clients_value', 'home', 'statsClientsValue', '3000', '3000', '数据统计-客户数', 12),
('stats_clients_label', 'home', 'statsClientsLabel', '服务企业数量', 'клиентов', '数据统计-客户标签', 13),
('stats_satisfaction_value', 'home', 'statsSatisfactionValue', '99', '99', '数据统计-满意度', 14),
('stats_satisfaction_label', 'home', 'statsSatisfactionLabel', '客户满意度', 'удовлетворенность', '数据统计-满意度标签', 15),
('stats_service_value', 'home', 'statsServiceValue', '24', '24', '数据统计-服务时长', 16),
('stats_service_label', 'home', 'statsServiceLabel', '全天候服务', 'круглосуточно', '数据统计-服务标签', 17),

-- 关于我们
('about_title', 'home', 'aboutTitle', '深耕中俄货运领域', 'Эксперты логистики', '关于我们标题', 20),
('about_subtitle', 'home', 'aboutSubtitle', '成为可靠的跨境桥梁', 'Китай — Россия', '关于我们副标题', 21),
('about_desc1', 'home', 'aboutDesc1', '满洲里欣琪国际货运代理有限责任公司深耕中俄货运领域多年，凭借扎根满洲里口岸的地理优势与对中俄贸易规则的深刻理解，成为连接两国货物往来的可靠桥梁。', 'Маньчжурия Синьци Международное Экспедирование — эксперт в сфере логистики Китай-Россия с многолетним опытом работы на границе.', '关于我们描述1', 22),
('about_desc2', 'home', 'aboutDesc2', '作为中俄贸易的见证者与参与者，欣琪国际始终以"安全、高效、透明"为服务准则，累计为数千家企业完成跨境货物运输。', 'Мы обслужили тысячи компаний, обеспечивая безопасность, эффективность и прозрачность на каждом этапе.', '关于我们描述2', 23),

-- 服务内容
('services_title', 'home', 'servicesTitle', '全方位中俄货运解决方案', 'Полный спектр услуг', '服务内容标题', 30),
('services_desc', 'home', 'servicesDesc', '满足不同客户的多样化需求，提供一站式跨境物流服务', 'Индивидуальные решения для каждого клиента', '服务内容描述', 31),

-- 核心竞争力
('advantages_title', 'home', 'advantagesTitle', '三重专业保障', 'Три уровня гарантии', '核心竞争力标题', 40),
('advantages_desc', 'home', 'advantagesDesc', '让我们成为中俄货运领域的可靠合作伙伴', 'Почему нам доверяют', '核心竞争力描述', 41),

-- 案例展示
('cases_title', 'home', 'casesTitle', '值得信赖的合作伙伴', 'Надежный партнер', '案例展示标题', 50),
('cases_desc', 'home', 'casesDesc', '我们已为数千家企业提供专业的中俄物流服务', 'Мы обслужили тысячи клиентов', '案例展示描述', 51),

-- 在线询价
('order_title', 'home', 'orderTitle', '立即提交您的运输需求', 'Отправьте заявку сейчас', '在线询价标题', 60),

-- 联系我们
('contact_title', 'home', 'contactTitle', '期待与您的合作', 'Ждем вашего звонка', '联系我们标题', 70),

-- 客户类型
('clients_title', 'home', 'clientsTitle', '我们服务的客户类型', 'Наши клиенты', '客户类型标题', 80)
ON CONFLICT (id) DO NOTHING;

-- 授权（根据Supabase配置调整）
-- GRANT SELECT ON i18n_content TO anon;
-- GRANT SELECT, INSERT, UPDATE ON i18n_content TO authenticated;
