import { NextResponse } from 'next/server';
import { getSupabaseClient } from '@/storage/database/supabase-client';

// GET /api/admin/me - 获取当前登录的管理员信息
export async function GET(request: Request) {
  try {
    const adminId = request.headers.get('cookie')
      ?.split(';')
      .find(c => c.trim().startsWith('admin_id='))
      ?.split('=')[1];
    
    if (!adminId) {
      return NextResponse.json(
        { authenticated: false },
        { status: 401 }
      );
    }
    
    const client = getSupabaseClient();
    
    const { data: admin, error } = await client
      .from('admins')
      .select('id, username, name, role')
      .eq('id', adminId)
      .eq('is_active', true)
      .single();
    
    if (error || !admin) {
      return NextResponse.json(
        { authenticated: false },
        { status: 401 }
      );
    }
    
    return NextResponse.json({
      authenticated: true,
      admin: {
        id: admin.id,
        username: admin.username,
        name: admin.name,
        role: admin.role,
      }
    });
  } catch (error) {
    console.error('Error:', error);
    return NextResponse.json(
      { authenticated: false },
      { status: 500 }
    );
  }
}
