import type { Metadata } from 'next';
import { Inspector } from 'react-dev-inspector';
import { Providers } from './providers';
import './globals.css';

export const metadata: Metadata = {
  title: {
    default: '满洲里欣琪国际货运代理有限责任公司',
    template: '%s | 欣琪国际货运',
  },
  description:
    '专业的中俄跨境物流解决方案提供商，打通中俄物流全链路，让跨境运输更简单。提供中俄公路运输、铁路运输、超大件设备运输、工程项目物流等全方位服务。',
  keywords: [
    '中俄物流',
    '满洲里货运',
    '国际货运代理',
    '中俄公路运输',
    '铁路运输',
    '跨境物流',
    '俄罗斯清关',
    '满洲里口岸',
    '货运代理',
    '中俄贸易',
  ],
  authors: [{ name: '欣琪国际货运' }],
  generator: 'Next.js',
  // icons: {
  //   icon: '',
  // },
  openGraph: {
    title: '扣子编程 | 你的 AI 工程师已就位',
    description:
      '我正在使用扣子编程 Vibe Coding，让创意瞬间上线。告别拖拽，拥抱心流。',
    url: 'https://code.coze.cn',
    siteName: '扣子编程',
    locale: 'zh_CN',
    type: 'website',
    // images: [
    //   {
    //     url: '',
    //     width: 1200,
    //     height: 630,
    //     alt: '扣子编程 - 你的 AI 工程师',
    //   },
    // ],
  },
  // twitter: {
  //   card: 'summary_large_image',
  //   title: 'Coze Code | Your AI Engineer is Here',
  //   description:
  //     'Build and deploy full-stack applications through AI conversation. No env setup, just flow.',
  //   // images: [''],
  // },
  robots: {
    index: true,
    follow: true,
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  const isDev = process.env.NODE_ENV === 'development';

  return (
    <html lang="zh">
      <body className={`antialiased font-sans`}>
        <Providers>
          {isDev && <Inspector />}
          {children}
        </Providers>
      </body>
    </html>
  );
}
