'use client';

import { createContext, useContext } from 'react';

interface AdminContextType {
  admin: {
    id: string;
    username: string;
    name: string;
    role: string;
  } | null;
  isLoading: boolean;
}

export const AdminContext = createContext<AdminContextType>({
  admin: null,
  isLoading: true,
});

export function useAdmin() {
  return useContext(AdminContext);
}
