'use client';

import { createContext, useContext } from 'react';

interface Customer {
  id: string;
  name: string;
  phone: string;
  email: string | null;
  company: string | null;
  created_at: string;
}

interface UserContextType {
  customer: Customer | null;
  setCustomer: (customer: Customer | null) => void;
  isLoading: boolean;
}

export const UserContext = createContext<UserContextType>({
  customer: null,
  setCustomer: () => {},
  isLoading: true,
});

export const useUser = () => useContext(UserContext);
