import { zh } from './locales/zh';
import { ru } from './locales/ru';

export type { Translation } from './locales/zh';

export const translations = {
  zh,
  ru,
} as const;

export type Locale = keyof typeof translations;

export const locales: Locale[] = ['zh', 'ru'];

export const localeNames: Record<Locale, string> = {
  zh: '中文',
  ru: 'Русский',
};

export { zh, ru };
