// 中文翻译
export const zh = {
  // 通用
  common: {
    logo: '欣琪国际货运',
    logoSub: 'XINQI FREIGHT',
    slogan: '中俄跨境物流专业服务商',
    loading: '加载中...',
    save: '保存',
    cancel: '取消',
    confirm: '确认',
    delete: '删除',
    edit: '编辑',
    add: '新增',
    search: '搜索',
    submit: '提交',
    back: '返回',
    preview: '预览',
    home: '首页',
    more: '了解更多',
    viewAll: '查看全部',
    close: '关闭',
  },

  // 导航栏
  nav: {
    home: '首页',
    about: '关于我们',
    services: '服务内容',
    cases: '案例展示',
    faqs: '常见问题',
    order: '在线询价',
    contact: '联系我们',
    userCenter: '用户中心',
    login: '登录',
    register: '注册',
    logout: '退出',
  },

  // 首页
  home: {
    heroTitle: '打通中俄物流全链路',
    heroSubtitle: '让跨境运输更简单',
    heroDesc: '专业的中俄跨境物流解决方案提供商，为您的货物保驾护航',
    inquiryNow: '立即询价',
    learnMore: '了解更多',
    
    stats: {
      years: '年行业经验',
      routes: '条运输线路',
      cities: '个覆盖城市',
      clients: '家服务客户',
    },
    
    about: {
      title: '关于我们',
      subtitle: '专业、可靠的中俄跨境物流服务商',
      desc1: '满洲里欣琪国际货运代理有限责任公司是一家专业从事中俄跨境物流的企业，总部位于中国最大的陆路口岸——满洲里。',
      desc2: '我们提供铁路运输、公路运输、清关服务、仓储配送等一站式物流解决方案，为客户打造安全、高效、经济的跨境运输体验。',
      feature1Title: '专业团队',
      feature1Desc: '拥有丰富中俄物流经验的专业团队',
      feature2Title: '全程跟踪',
      feature2Desc: '实时货物追踪，让您随时掌握动态',
      feature3Title: '优质服务',
      feature3Desc: '7×24小时客服支持，快速响应需求',
      feature4Title: '安全可靠',
      feature4Desc: '完善的保险体系，保障货物安全',
    },
    
    services: {
      title: '我们的服务',
      subtitle: '全方位中俄跨境物流解决方案',
      railway: '铁路运输',
      railwayDesc: '中欧班列、满洲里口岸过境运输，时效稳定，成本优惠',
      road: '公路运输',
      roadDesc: '灵活的公路运输方案，门到门服务，适合时效要求高的货物',
      customs: '清关服务',
      customsDesc: '专业的清关团队，熟悉中俄贸易法规，确保通关顺畅',
      warehouse: '仓储服务',
      warehouseDesc: '满洲里、俄罗斯多地仓库，提供短期存储和分销服务',
    },
    
    order: {
      title: '在线询价',
      subtitle: '填写您的运输需求，我们将为您提供最优方案',
      contactName: '联系人',
      contactNamePlaceholder: '请输入联系人姓名',
      contactPhone: '联系电话',
      contactPhonePlaceholder: '请输入手机号码',
      contactEmail: '电子邮箱',
      contactEmailPlaceholder: '请输入邮箱（选填）',
      originCity: '起运地',
      originCityPlaceholder: '请输入中国城市名称',
      destinationCity: '目的地',
      destinationCityPlaceholder: '请输入俄罗斯城市名称',
      customsCity: '清关地点',
      customsCityPlaceholder: '请输入俄罗斯清关城市',
      notes: '备注信息',
      notesPlaceholder: '请描述货物类型、重量、体积等信息...',
      submit: '提交询价',
      submitting: '提交中...',
      submitSuccess: '询价提交成功！',
      submitSuccessDesc: '我们会在24小时内与您联系，请保持电话畅通。',
    },
    
    contact: {
      title: '联系我们',
      subtitle: '欢迎随时联系咨询',
      address: '公司地址',
      addressValue: '内蒙古自治区满洲里市',
      phone: '联系电话',
      email: '电子邮箱',
      wechat: '微信公众号',
      workingHours: '工作时间',
      workingHoursValue: '周一至周六 9:00-18:00',
    },
    
    footer: {
      copyright: '© 2025 满洲里欣琪国际货运代理有限责任公司 版权所有',
      icp: '蒙ICP备XXXXXXXX号',
    },
  },

  // 服务页面
  services: {
    title: '服务内容',
    subtitle: '全方位中俄跨境物流解决方案',
    railway: '铁路运输',
    road: '公路运输',
    customs: '清关服务',
    warehouse: '仓储服务',
    // 新增
    all: '全部',
    roadTransport: '公路运输',
    railTransport: '铁路运输',
    portService: '口岸服务',
    specialLogistics: '特殊物流',
    otherService: '其他服务',
    noServices: '暂无服务内容',
    backToList: '返回服务列表',
    serviceNotFound: '服务不存在',
    serviceDetail: '服务详情',
    serviceFeatures: '服务特点',
    serviceProcess: '服务流程',
    importExportPolicy: '进出口监管政策',
    requiredDocuments: '所需资料',
    relatedDocuments: '相关文档',
    clickToDownload: '点击查看/下载',
    inquiryNow: '立即询价',
    quickInquiry: '快速询价',
    inquiryDesc: '填写您的运输需求，我们将为您提供最优方案',
    contactName: '联系人',
    contactNamePlaceholder: '请输入联系人姓名',
    contactPhone: '联系电话',
    contactPhonePlaceholder: '请输入手机号码',
    contactEmail: '电子邮箱',
    contactEmailPlaceholder: '请输入邮箱（选填）',
    originCity: '起运地',
    originCityPlaceholder: '请输入中国城市名称',
    destinationCity: '目的地',
    destinationCityPlaceholder: '请输入俄罗斯城市名称',
    customsCity: '清关地点',
    customsCityPlaceholder: '请输入俄罗斯清关城市',
    notes: '备注信息',
    notesPlaceholder: '请描述货物类型、重量、体积等信息...',
    submit: '提交询价',
    submitting: '提交中...',
    submitSuccess: '询价提交成功！',
    submitSuccessDesc: '我们会在24小时内与您联系，请保持电话畅通。',
    submitError: '提交失败，请稍后重试',
  },

  // 案例页面
  cases: {
    title: '案例展示',
    subtitle: '展示我们成功完成的中俄跨境物流项目，为您提供参考',
    noCases: '暂无案例',
    noCasesDesc: '案例内容正在整理中，敬请期待',
    viewImages: '查看全部图片',
    images: '张',
  },

  // 常见问题页面
  faqs: {
    title: '常见问题',
    subtitle: '整理了客户最关心的常见问题，帮助您快速了解我们的服务',
    searchPlaceholder: '搜索问题...',
    all: '全部',
    noResults: '没有找到相关问题',
    notFound: '没有找到您的问题？',
    contactUs: '联系我们',
    categories: {
      transport: '运输问题',
      customs: '清关问题',
      cost: '费用问题',
      cooperation: '合作问题',
      other: '其他',
    },
  },

  // 用户中心
  user: {
    orders: '我的订单',
    ordersDesc: '查看和管理您的所有订单',
    newInquiry: '新建询价',
    login: '登录',
    register: '注册',
    loginTitle: '用户登录',
    registerTitle: '用户注册',
    phone: '手机号码',
    phonePlaceholder: '请输入手机号码',
    password: '密码',
    passwordPlaceholder: '请输入密码',
    confirmPassword: '确认密码',
    confirmPasswordPlaceholder: '请再次输入密码',
    name: '姓名',
    namePlaceholder: '请输入您的姓名',
    email: '邮箱',
    emailPlaceholder: '请输入邮箱（选填）',
    company: '公司名称',
    companyPlaceholder: '请输入公司名称（选填）',
    noAccount: '还没有账号？',
    hasAccount: '已有账号？',
    goLogin: '立即登录',
    goRegister: '立即注册',
    // 侧边栏
    backHome: '返回首页',
    logistics: '物流服务',
    services: '服务内容',
    orderManagement: '订单管理',
    personalSettings: '个人设置',
    editProfile: '编辑资料',
    changePassword: '修改密码',
    changeEmail: '修改邮箱',
    // 设置页面
    settings: {
      editProfileTitle: '编辑资料',
      editProfileDesc: '更新您的个人信息',
      changePasswordTitle: '修改密码',
      changePasswordDesc: '定期修改密码可以提高账户安全性',
      changeEmailTitle: '修改邮箱',
      changeEmailDesc: '绑定或修改您的邮箱地址',
      // 表单字段
      name: '姓名',
      phone: '手机号',
      company: '公司名称',
      currentEmail: '当前邮箱',
      noEmail: '未绑定邮箱',
      goToChangeEmail: '修改邮箱',
      goToChangeEmailDesc: '如需修改邮箱，请前往',
      page: '页面',
      // 密码相关
      currentPassword: '当前密码',
      newPassword: '新密码',
      confirmNewPassword: '确认新密码',
      passwordPlaceholder: '请输入当前密码',
      newPasswordPlaceholder: '请输入新密码（至少6个字符）',
      confirmPasswordPlaceholder: '请再次输入新密码',
      loginPassword: '登录密码',
      // 邮箱相关
      verifyPassword: '验证密码',
      verifyPasswordDesc: '请输入您的登录密码以继续',
      securityVerify: '安全验证',
      setNewEmail: '设置新邮箱',
      newEmail: '新邮箱',
      newEmailPlaceholder: '请输入新的邮箱地址',
      // 步骤
      step1: '验证密码',
      step2: '设置邮箱',
      // 按钮
      save: '保存修改',
      saving: '保存中...',
      verify: '验证密码',
      verifying: '验证中...',
      // 消息
      updateSuccess: '资料更新成功！',
      updateFailed: '更新失败',
      passwordSuccess: '密码修改成功！',
      passwordFailed: '修改失败',
      emailSuccess: '邮箱修改成功！',
      emailFailed: '修改失败',
      passwordMinLength: '新密码至少需要6个字符',
      passwordMismatch: '两次输入的新密码不一致',
      networkError: '网络错误，请重试',
      passwordVerifyFailed: '密码验证失败',
      // 占位符
      namePlaceholder: '请输入您的姓名',
      phonePlaceholder: '请输入11位手机号',
      companyPlaceholder: '请输入公司名称（选填）',
    },
  },

  // 订单状态
  orderStatus: {
    newInquiry: '新询价',
    pendingConfirm: '待确认',
    loadingPlan: '装车方案设计中',
    confirmed: '确认',
    inTransitCN: '运输中（中国境内）',
    manzhouliStorage: '满洲里仓储中',
    customsUnfinished: '清关未完成',
    inTransitRU: '运输中（俄罗斯境内）',
    delivered: '配送完成',
  },

  // 订单详情
  order: {
    orderNumber: '订单号',
    status: '状态',
    contact: '联系人',
    phone: '电话',
    email: '邮箱',
    origin: '起运地',
    destination: '目的地',
    customs: '清关地',
    notes: '备注',
    createdAt: '创建时间',
    updatedAt: '更新时间',
    confirmOrder: '确认订单',
    confirmSuccess: '订单已确认',
    sendMessage: '发送消息',
    messagePlaceholder: '请输入消息内容...',
    noMessages: '暂无消息记录',
    uploading: '上传中...',
    attachImage: '上传图片',
    attachFile: '上传文件',
    // 新增
    detail: '详情',
    collapse: '收起',
    contactInfo: '联系人信息',
    transportInfo: '运输信息',
    timeInfo: '时间信息',
    originCity: '起运地',
    destCity: '目的地',
    customsCity: '清关地',
    createTime: '创建时间',
    updateTime: '更新时间',
    notesInfo: '备注信息',
    transportConfirmed: '运输方案已发送',
    transportConfirmDesc: '请确认运输方案后点击确认按钮',
    transportConfirm: '运输确认',
    confirming: '确认中...',
    orderChat: '订单沟通',
    orderChatDesc: '与客服实时交流',
    totalOrders: '个订单',
    newMessages: '条新消息',
    noOrders: '暂无订单记录',
    noOrdersDesc: '您还没有提交过询价订单',
    confirmDialog: '确认接受运输方案？确认后订单将进入执行阶段。',
    confirmFailed: '确认失败，请稍后重试',
    orderNotFound: '订单不存在',
    loadFailed: '加载订单失败',
    checkOrderNumber: '请检查订单号是否正确',
    backToList: '返回订单列表',
    orderDetail: '订单详情',
    route: '路线',
    china: '中国',
    russia: '俄罗斯',
    planSent: '运输方案已发送',
    planSentDesc: '请确认后开始执行',
    confirmPlanMsg: '确认接受运输方案？确认后订单将进入执行阶段。',
    confirmTransport: '确认运输方案',
  },

  // 后台管理
  admin: {
    dashboard: '仪表盘',
    orders: '订单管理',
    customers: '客户管理',
    services: '服务内容',
    cases: '案例管理',
    faqs: '常见问题',
    backToHome: '前台首页',
    logout: '退出',
    admin: '管理员',
    superAdmin: '超级管理员',
    loginTitle: '管理员登录',
    username: '用户名',
    usernamePlaceholder: '请输入用户名',
    passwordPlaceholder: '请输入密码',
  },
};

export type Translation = typeof zh;
